import asyncio
import websockets
import json
from pyrogram import Client 

api_id = 20092044
api_hash = "8570570a50fe2f8d51ab511a8df3fb3e"


app = Client("bot", api_id=api_id, api_hash=api_hash)

async def handler(websocket):
    async for message in websocket:
        try:
            data = json.loads(message)
            if data["action"] == "send_gift":
                chat_id = data["chat_id"]
                gift_id = int(data["gift_id"])
                count = int(data.get("count", 1))
                success = 0
                for i in range(count):
                    try:
                        await app.send_gift(chat_id=chat_id, gift_id=gift_id)
                        success += 1
                    except Exception as e:
                        await websocket.send(json.dumps({
                            "status": "error",
                            "message": f"❌ Failed on iteration {i+1}: {str(e)}"
                        }))
                        break
                await websocket.send(json.dumps({"status": "ok"}))
            else:
                await websocket.send(json.dumps({"status": "unknown_action"}))
        except Exception as e:
            await websocket.send(json.dumps({"status": "error", "message": str(e)}))

async def websocket_server():
    async with websockets.serve(handler, "localhost", 8767):
        print("✅ WebSocket ready on ws://localhost:8767")
        await asyncio.Future()

async def main():
    await app.start()
    await websocket_server()

loop = asyncio.get_event_loop()
loop.run_until_complete(main())